// TriangulatorMarchCubes.h
// Definit la classe du trianguleur par la methode des marching cubes

#ifndef V3D_BLOBS_TRIANGULATOR_MARCH_CUBES_H_INCLUDED
#define V3D_BLOBS_TRIANGULATOR_MARCH_CUBES_H_INCLUDED

#include "Triangulator.h"

namespace V3D {



//////////////////////////////////////////////////////////////////////////////////////////
class TriangulatorMarchCubes : public Triangulator
{
// Types de donnees
	typedef Triangulator parent;

protected:

// Une configuration de cube decrit entre 0 et 5 triangles
//	typedef SCubeTriangle SCubeConf[5];
	struct SCubeConf
	{
		// Definit un triangle de la marching cube:
		// les 3 indices sont les indices des arretes du cube sur lesquelles se trouvent les 3 vertices du triangle
		// (a = b = c = -1 signifie pas de triangle)
		struct SCubeTriangle
		{
			int8	a, b, c;
		};

		uint32         nTriCount;
		SCubeTriangle  aTriangles[5];
	};

								////////////////////////////////////



public:
	TriangulatorMarchCubes (const Vector3D& vcCenterGrid, const Vector3D& vcSize, 
						   int32 nDivideX, int32 nDivideY, int32 nDivideZ);
	virtual ~TriangulatorMarchCubes();

	Vector3D GetSize() const;
	Vector3D GetGridPoint(int32 nPointX, int32 nPointY, int32 nPointZ) const;
	const Vector3D& GetCorner() const          {return m_vcCornerPos;}
	const Vector3D& GetCubeElementSize() const {return m_vcMarchCubeSize;}

	const int32& GetDivideX() const {return m_nDivideX; }
	const int32& GetDivideY() const {return m_nDivideY; }
	const int32& GetDivideZ() const {return m_nDivideZ; }


public:	// donnees membres publiques

protected: // Methodes protegees
	// Definit les infos de la grille. Protegee car les classes derivees doivent s'initialiser apres.
	void SetGridInfo( const Vector3D& vcCornerPos, const Vector3D& vcSize, 
					  int32 nDivideX, int32 nDivideY, int32 nDivideZ);

	void ComputeUsefulSubGrid( int32& nStartCubeX, int32& nCubesX,
	                           int32& nStartCubeY, int32& nCubesY,
	                           int32& nStartCubeZ, int32& nCubesZ,
	                           const IsoSurface& iso) const;


protected: // Donnees membres protegees
	// Table des configurations possibles du cube: pour chaque combinaison interieur/exterieur
	// des sommets, fournit les triangles du cube a generer
	static	const SCubeConf	          k_aCubeConfs[256];

private: // Donnees membres privees
	Vector3D    m_vcCornerPos;     // Position du coin inferieur
	Vector3D    m_vcMarchCubeSize; // Determine la taille d'un petit cube dans chaque direction

	int32               m_nDivideX; // Subdivision du grand cube en marching cubes (en X)
	int32               m_nDivideY; // idem en Y
	int32               m_nDivideZ; // idem en Z

};

//////////////////////////////////////////////////////////////////////////////////////////


} // namespace


#endif	// #ifndef V3D_BLOBS_TRIANGULATOR_MARCH_CUBES_H_INCLUDED

